<?php
require 'koneksi.php';

$id_gudang = $_GET['id_gudang'] ?? null;
$tahun     = $_GET['tahun'] ?? null;

if (!$id_gudang || !$tahun) {
    echo "Parameter gudang atau tahun tidak lengkap.";
    exit;
}

// Ambil nama gudang
$sql_gudang = "SELECT nama_gudang FROM gudang_tahun WHERE id_gudang = ? AND tahun = ?";
$stmt_gudang = $conn->prepare($sql_gudang);
$stmt_gudang->bind_param("ss", $id_gudang, $tahun);
$stmt_gudang->execute();
$result_gudang = $stmt_gudang->get_result();
$nama_gudang = ($row = $result_gudang->fetch_assoc()) ? $row['nama_gudang'] : 'Tidak ditemukan';

// Ambil data hasil_opname dengan JOIN ke barang
$sql = "SELECT ho.*, b.nama_barang
        FROM hasil_opname ho
        JOIN barang b ON ho.id_barang = b.id_barang
        WHERE ho.id_gudang = ? AND ho.tahun = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $id_gudang, $tahun);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Data Hasil Opname</title>
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
            margin-top: 20px;
        }

        th, td {
            border: 1px solid #999;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #eee;
        }
    </style>
</head>
<body>

<h2>Data Hasil Opname</h2>
<p><strong>Gudang:</strong> <?= htmlspecialchars($nama_gudang) ?> | <strong>Tahun:</strong> <?= htmlspecialchars($tahun) ?></p>
<a href="export_opname_excel.php?id_gudang=<?= $id_gudang ?>&tahun=<?= $tahun ?>" class="btn btn-success">
    Download Excel
</a>

<?php if ($result->num_rows > 0): ?>
    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Nama Barang</th>
                <th>Part Number</th>
                <th>Stock Awal</th>
                <th>Kondisi Bagus</th>
                <th>Kondisi Rusak</th>
                <th>Stock Akhir</th>
                <th>Satuan</th>
                <th>Barcode</th>
            </tr>
        </thead>
        <tbody>
            <?php $no = 1; while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= $no++ ?></td>
                    <td><?= htmlspecialchars($row['nama_barang']) ?></td>
                    <td><?= htmlspecialchars($row['part_number']) ?></td>
                    <td><?= number_format($row['stock_awal']) ?></td>
                    <td><?= number_format($row['kondisi_bagus']) ?></td>
                    <td><?= number_format($row['kondisi_rusak']) ?></td>
                    <td><?= number_format($row['stock_akhir']) ?></td>
                    <td><?= htmlspecialchars($row['satuan']) ?></td>
                    <td><?= htmlspecialchars($row['barcode']) ?></td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
<?php else: ?>
    <p>Tidak ada data untuk gudang dan tahun yang dipilih.</p>
<?php endif; ?>

</body>
</html>
